package ShallowWellPumpingSystem
  model StopValve "Valve for (almost) incompressible fluids"
    extends Modelica.Fluid.Valves.BaseClasses.PartialValve(CvData = Modelica.Fluid.Types.CvTypes.Av, Av = 3.68008e-5, dp_nominal = 1e5, m_flow_nominal = 0.3);
    import Modelica.Fluid.Types.CvTypes;
    import Modelica.Constants.pi;
    import SI = Modelica.SIunits;
    import Modelica.Fluid.Utilities;
    constant SI.ReynoldsNumber Re_turbulent = 4000 "cf. straight pipe for fully open valve -- dp_turbulent increases for closing valve";
    parameter Boolean use_Re = system.use_eps_Re "= true, if turbulent region is defined by Re, otherwise by m_flow_small" annotation(
      Dialog(tab = "Advanced"),
      Evaluate = true);
    //SI.MassFlowRate m_flow_turbulent=if not use_Re then m_flow_small else
    //  max(m_flow_small,
    //      (Modelica.Constants.pi/8)*sqrt(max(relativeFlowCoefficient,0.001)*Av*4/pi)*(Medium.dynamicViscosity(state_a) + Medium.dynamicViscosity(state_b))*Re_turbulent);
    //SI.AbsolutePressure dp_turbulent_=if not use_Re then dp_small else
    //  max(dp_small, m_flow_turbulent^2/(max(relativeFlowCoefficient,0.001)^2*Av^2*(Medium.density(state_a) + Medium.density(state_b))/2));
    // substitute m_flow_turbulent into dp_turbulent
    SI.AbsolutePressure dp_turbulent = if not use_Re then dp_small else max(dp_small, (Medium.dynamicViscosity(state_a) + Medium.dynamicViscosity(state_b)) ^ 2 * pi / 8 * Re_turbulent ^ 2 / (max(relativeFlowCoefficient, 0.001) * Av * (Medium.density(state_a) + Medium.density(state_b))));
    Modelica.Blocks.Tables.CombiTable1D valveCharacteristicTable(smoothness = Modelica.Blocks.Types.Smoothness.MonotoneContinuousDerivative1, table = [0, 0; 0.052631579, 0.271493213; 0.157894737, 0.542986425; 0.210526316, 0.601809955; 0.263157895, 0.633484163; 0.368421053, 0.791855204; 0.473684211, 0.882352941; 0.631578947, 0.972850679; 0.789473684, 0.995475113; 1, 1]) annotation(
      Placement(visible = true, transformation(origin = {106, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  protected
    Real relativeFlowCoefficient;
  initial equation
    if CvData == CvTypes.OpPoint then
      m_flow_nominal = valveCharacteristic(opening_nominal) * Av * sqrt(rho_nominal) * Utilities.regRoot(dp_nominal, dp_small) "Determination of Av by the operating point";
    end if;
  equation
    connect(valveCharacteristicTable.u[1], opening_actual) annotation(
      Line(points = {{94, 20}, {70, 20}}, color = {0, 0, 127}));
// m_flow = valveCharacteristic(opening)*Av*sqrt(d)*sqrt(dp);
    relativeFlowCoefficient = valveCharacteristicTable.y[1];
    if checkValve then
      m_flow = homotopy(relativeFlowCoefficient * Av * sqrt(Medium.density(state_a)) * Utilities.regRoot2(dp, dp_turbulent, 1.0, 0.0, use_yd0 = true, yd0 = 0.0), relativeFlowCoefficient * m_flow_nominal * dp / dp_nominal);
/* In Modelica 3.1 (Disadvantage: Unnecessary event at dp=0, and instead of smooth=2)
  m_flow = valveCharacteristic(opening)*Av*sqrt(Medium.density(state_a))*
                (if dp>=0 then Utilities.regRoot(dp, dp_turbulent) else 0);
  */
    elseif not allowFlowReversal then
      m_flow = homotopy(relativeFlowCoefficient * Av * sqrt(Medium.density(state_a)) * Utilities.regRoot(dp, dp_turbulent), relativeFlowCoefficient * m_flow_nominal * dp / dp_nominal);
    else
      m_flow = homotopy(relativeFlowCoefficient * Av * Utilities.regRoot2(dp, dp_turbulent, Medium.density(state_a), Medium.density(state_b)), relativeFlowCoefficient * m_flow_nominal * dp / dp_nominal);
/* In Modelica 3.1 (Disadvantage: Unnecessary event at dp=0, and instead of smooth=2)
  m_flow = smooth(0, Utilities.regRoot(dp, dp_turbulent)*(if dp>=0 then sqrt(Medium.density(state_a)) else sqrt(Medium.density(state_b))));
  */
    end if;
    annotation(
      Documentation(info = "<html>
<p>
Valve model according to the IEC 534/ISA S.75 standards for valve sizing, incompressible fluids.</p>

<p>
The parameters of this model are explained in detail in
<a href=\"modelica://Modelica.Fluid.Valves.BaseClasses.PartialValve\">PartialValve</a>
(the base model for valves).
</p>

<p>
This model assumes that the fluid has a low compressibility, which is always the case for liquids.
It can also be used with gases, provided that the pressure drop is lower than 0.2 times the absolute pressure at the inlet, so that the fluid density does not change much inside the valve.</p>

<p>
If <code>checkValve</code> is false, the valve supports reverse flow, with a symmetric flow characteristic curve. Otherwise, reverse flow is stopped (check valve behaviour).
</p>

<p>
The treatment of parameters <strong>Kv</strong> and <strong>Cv</strong> is
explained in detail in the
<a href=\"modelica://Modelica.Fluid.UsersGuide.ComponentDefinition.ValveCharacteristics\">User's Guide</a>.
</p>

</html>", revisions = "<html>
<ul>
<li><em>2 Nov 2005</em>
  by <a href=\"mailto:francesco.casella@polimi.it\">Francesco Casella</a>:<br>
     Adapted from the ThermoPower library.</li>
</ul>
</html>"));
  end StopValve;

  model StopValveTest1
    replaceable package Medium = Modelica.Media.Water.StandardWater;
    ShallowWellPumpingSystem.StopValve stopValve1(redeclare package Medium = Medium) annotation(
      Placement(visible = true, transformation(origin = {0, -4}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Sources.Boundary_pT boundary(redeclare package Medium = Medium, T = 293.15, nPorts = 1, p = 101325 + 1e5) annotation(
      Placement(visible = true, transformation(origin = {-62, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Sources.Boundary_pT boundary1(redeclare package Medium = Medium, T = 293.15, nPorts = 1, p = 101325) annotation(
      Placement(visible = true, transformation(origin = {60, -6}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Ramp ramp1(duration = 10) annotation(
      Placement(visible = true, transformation(origin = {-30, 32}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    inner Modelica.Fluid.System system annotation(
      Placement(visible = true, transformation(origin = {58, 32}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(ramp1.y, stopValve1.opening) annotation(
      Line(points = {{-18, 32}, {0, 32}, {0, 4}, {0, 4}}, color = {0, 0, 127}));
    connect(stopValve1.port_b, boundary1.ports[1]) annotation(
      Line(points = {{10, -4}, {50, -4}, {50, -6}, {50, -6}}, color = {0, 127, 255}));
    connect(boundary.ports[1], stopValve1.port_a) annotation(
      Line(points = {{-52, -6}, {-10, -6}, {-10, -4}, {-10, -4}}, color = {0, 127, 255}));
    annotation(
      experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-6, Interval = 0.02),
      __OpenModelica_simulationFlags(lv = "LOG_STATS", outputFormat = "mat", s = "dassl"));
  end StopValveTest1;
  annotation(
    uses(Modelica(version = "3.2.3")));
end ShallowWellPumpingSystem;
