package ValveExample3
  function avCurve1
    extends Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun;
  algorithm
    rc := (((((-9.1683 * pos) + 19.855) * pos - 12.964) * pos + 3.0747) * pos + 0.2061) * pos;
  end avCurve1;

  function xtCurve1
    extends Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun;
  algorithm
    rc := ((((((-45.881 * pos) + 152.17) * pos - 183.4) * pos + 94.103) * pos - 15.827) * pos - 1.6945) * pos + 1;
  end xtCurve1;

  model AngleValveTesrt1
    replaceable package Medium = Modelica.Media.Air.DryAirNasa;
    Modelica.Fluid.Sources.Boundary_pT boundary(redeclare package Medium = Medium, T = 273.15, nPorts = 1, p = 102825) annotation(
      Placement(visible = true, transformation(origin = {-56, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Sources.Boundary_pT boundary_pT(redeclare package Medium = Medium, T = 273.15, nPorts = 1, p = 101325) annotation(
      Placement(visible = true, transformation(origin = {54, 14}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
    Modelica.Fluid.Valves.ValveCompressible valveCompressible(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, redeclare function xtCharacteristic = xtCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-4, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Ramp ramp(duration = 10, height = 1, offset = 0) annotation(
      Placement(visible = true, transformation(origin = {-30, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    inner Modelica.Fluid.System system annotation(
      Placement(visible = true, transformation(origin = {54, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(valveCompressible.port_a, boundary.ports[1]) annotation(
      Line(points = {{-14, 14}, {-46, 14}}));
    connect(valveCompressible.port_b, boundary_pT.ports[1]) annotation(
      Line(points = {{6, 14}, {44, 14}}, color = {0, 127, 255}));
    connect(ramp.y, valveCompressible.opening) annotation(
      Line(points = {{-18, 52}, {-4, 52}, {-4, 22}, {-4, 22}}, color = {0, 0, 127}));
    annotation(
      experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-06, Interval = 0.02));
  end AngleValveTesrt1;

  model AngleValveTesrt2
    replaceable package Medium = Modelica.Media.Air.DryAirNasa;
    Modelica.Fluid.Sources.Boundary_pT boundary(redeclare package Medium = Medium, T = 273.15, nPorts = 3, p = 201325) annotation(
      Placement(visible = true, transformation(origin = {-74, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Sources.Boundary_pT boundary_pT(redeclare package Medium = Medium, T = 273.15, nPorts = 3, p = 101325, use_p_in = true) annotation(
      Placement(visible = true, transformation(origin = {54, 14}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
    Modelica.Fluid.Valves.ValveCompressible valveCompressible(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, redeclare function xtCharacteristic = xtCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-4, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    inner Modelica.Fluid.System system annotation(
      Placement(visible = true, transformation(origin = {54, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Constant const(k = 1) annotation(
      Placement(visible = true, transformation(origin = {-44, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Ramp ramp(duration = 10, height = -90000, offset = 201325) annotation(
      Placement(visible = true, transformation(origin = {48, -26}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Valves.ValveCompressible valveCompressible1(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, redeclare function xtCharacteristic = xtCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-2, -22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Valves.ValveCompressible valveCompressible2(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, redeclare function xtCharacteristic = xtCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-2, -56}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Constant const1(k = 0.8) annotation(
      Placement(visible = true, transformation(origin = {-44, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Constant const2(k = 0.4) annotation(
      Placement(visible = true, transformation(origin = {-44, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpression(y = sqrt(valveCompressible.dp / valveCompressible.p)) annotation(
      Placement(visible = true, transformation(origin = {-42, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpression1(y = sqrt(valveCompressible1.dp / valveCompressible1.p)) annotation(
      Placement(visible = true, transformation(origin = {-10, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpression2(y = sqrt(valveCompressible2.dp / valveCompressible2.p)) annotation(
      Placement(visible = true, transformation(origin = {26, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(valveCompressible.port_a, boundary.ports[1]) annotation(
      Line(points = {{-14, 14}, {-64, 14}}));
    connect(valveCompressible.port_b, boundary_pT.ports[1]) annotation(
      Line(points = {{6, 14}, {44, 14}}, color = {0, 127, 255}));
    connect(const.y, valveCompressible.opening) annotation(
      Line(points = {{-33, 34}, {-17.5, 34}, {-17.5, 22}, {-4, 22}}, color = {0, 0, 127}));
    connect(ramp.y, boundary_pT.p_in) annotation(
      Line(points = {{59, -26}, {84, -26}, {84, 22}, {66, 22}}, color = {0, 0, 127}));
    connect(boundary.ports[2], valveCompressible1.port_a) annotation(
      Line(points = {{-64, 14}, {-30, 14}, {-30, -22}, {-12, -22}}, color = {0, 127, 255}));
    connect(boundary.ports[3], valveCompressible2.port_a) annotation(
      Line(points = {{-64, 14}, {-30, 14}, {-30, -56}, {-12, -56}}, color = {0, 127, 255}));
    connect(valveCompressible1.port_b, boundary_pT.ports[2]) annotation(
      Line(points = {{8, -22}, {26, -22}, {26, 14}, {44, 14}, {44, 14}, {44, 14}}, color = {0, 127, 255}));
    connect(valveCompressible2.port_b, boundary_pT.ports[3]) annotation(
      Line(points = {{8, -56}, {26, -56}, {26, 14}, {44, 14}, {44, 14}}, color = {0, 127, 255}));
    connect(const1.y, valveCompressible1.opening) annotation(
      Line(points = {{-32, -6}, {-4, -6}, {-4, -12}, {-2, -12}, {-2, -14}}, color = {0, 0, 127}));
    connect(const2.y, valveCompressible2.opening) annotation(
      Line(points = {{-32, -40}, {-2, -40}, {-2, -48}, {-2, -48}}, color = {0, 0, 127}));
    annotation(
      experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-06, Interval = 0.02));
  end AngleValveTesrt2;

  model AngleValveTesrt3
    replaceable package Medium = Modelica.Media.Air.DryAirNasa;
    Modelica.Fluid.Sources.Boundary_pT boundary(redeclare package Medium = Medium, T = 273.15, nPorts = 6, p = 201325) annotation(
      Placement(visible = true, transformation(origin = {-74, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Sources.Boundary_pT boundary_pT(redeclare package Medium = Medium, T = 273.15, nPorts = 6, p = 101325, use_p_in = true) annotation(
      Placement(visible = true, transformation(origin = {44, 14}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
    inner Modelica.Fluid.System system annotation(
      Placement(visible = true, transformation(origin = {52, 84}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Constant const(k = 1) annotation(
      Placement(visible = true, transformation(origin = {-76, 86}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Ramp ramp(duration = 10, height = -110000, offset = 201325) annotation(
      Placement(visible = true, transformation(origin = {48, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Valves.ValveCompressible valveCompressible(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, redeclare function xtCharacteristic = xtCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-26, 76}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleA valveCompressibleA(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-26, 44}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleA valveCompressibleA1(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, redeclare function flCharacteristic = flCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fl_max = 0.89106678, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-26, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleB valveCompressibleB(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-26, -18}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleC valveCompressibleC(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-26, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleD valveCompressibleD(redeclare package Medium = Medium, redeclare function valveCharacteristic = avCurve1, redeclare function c1Characteristic = flCurve1, Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-26, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpressionB(y = sqrt(valveCompressibleB.dp / valveCompressibleB.p)) annotation(
      Placement(visible = true, transformation(origin = {2, -30}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpressionC(y = sqrt(valveCompressibleC.dp / valveCompressibleC.p)) annotation(
      Placement(visible = true, transformation(origin = {2, -62}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpressionD(y = sqrt(valveCompressibleD.dp / valveCompressibleD.p)) annotation(
      Placement(visible = true, transformation(origin = {2, -94}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpression(y = sqrt(valveCompressible.dp / valveCompressible.p)) annotation(
      Placement(visible = true, transformation(origin = {2, 64}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpressionA(y = sqrt(valveCompressibleA.dp / valveCompressibleA.p)) annotation(
      Placement(visible = true, transformation(origin = {2, 32}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpressionA1(y = sqrt(valveCompressibleA1.dp / valveCompressibleA1.p)) annotation(
      Placement(visible = true, transformation(origin = {4, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(ramp.y, boundary_pT.p_in) annotation(
      Line(points = {{59, -20}, {78, -20}, {78, 22}, {56, 22}}, color = {0, 0, 127}));
    connect(boundary.ports[1], valveCompressibleB.port_a) annotation(
      Line(points = {{-64, 14}, {-54, 14}, {-54, -18}, {-36, -18}}, color = {0, 127, 255}));
    connect(boundary.ports[2], valveCompressibleC.port_a) annotation(
      Line(points = {{-64, 14}, {-54, 14}, {-54, -50}, {-36, -50}}, color = {0, 127, 255}));
    connect(boundary.ports[3], valveCompressibleD.port_a) annotation(
      Line(points = {{-64, 14}, {-54, 14}, {-54, -82}, {-36, -82}}, color = {0, 127, 255}));
    connect(const.y, valveCompressibleB.opening) annotation(
      Line(points = {{-64, 86}, {-44, 86}, {-44, -8}, {-26, -8}, {-26, -10}}, color = {0, 0, 127}));
    connect(const.y, valveCompressibleC.opening) annotation(
      Line(points = {{-64, 86}, {-44, 86}, {-44, -40}, {-26, -40}, {-26, -42}}, color = {0, 0, 127}));
    connect(const.y, valveCompressibleD.opening) annotation(
      Line(points = {{-64, 86}, {-44, 86}, {-44, -72}, {-26, -72}, {-26, -74}}, color = {0, 0, 127}));
    connect(valveCompressibleB.port_b, boundary_pT.ports[1]) annotation(
      Line(points = {{-16, -18}, {18, -18}, {18, 14}, {34, 14}}, color = {0, 127, 255}));
    connect(valveCompressibleC.port_b, boundary_pT.ports[2]) annotation(
      Line(points = {{-16, -50}, {18, -50}, {18, 14}, {34, 14}}, color = {0, 127, 255}));
    connect(valveCompressibleD.port_b, boundary_pT.ports[3]) annotation(
      Line(points = {{-16, -82}, {18, -82}, {18, 14}, {34, 14}}, color = {0, 127, 255}));
    connect(valveCompressible.port_b, boundary_pT.ports[4]) annotation(
      Line(points = {{-16, 76}, {18, 76}, {18, 14}, {34, 14}}, color = {0, 127, 255}));
    connect(const.y, valveCompressible.opening) annotation(
      Line(points = {{-64, 86}, {-26, 86}, {-26, 84}}, color = {0, 0, 127}));
    connect(const.y, valveCompressibleA.opening) annotation(
      Line(points = {{-64, 86}, {-44, 86}, {-44, 54}, {-26, 54}, {-26, 52}}, color = {0, 0, 127}));
    connect(valveCompressibleA.port_b, boundary_pT.ports[5]) annotation(
      Line(points = {{-16, 44}, {18, 44}, {18, 14}, {34, 14}}, color = {0, 127, 255}));
    connect(boundary.ports[4], valveCompressible.port_a) annotation(
      Line(points = {{-64, 14}, {-54, 14}, {-54, 76}, {-36, 76}}, color = {0, 127, 255}));
    connect(boundary.ports[5], valveCompressibleA.port_a) annotation(
      Line(points = {{-64, 14}, {-54, 14}, {-54, 44}, {-36, 44}}, color = {0, 127, 255}));
    connect(const.y, valveCompressibleA1.opening) annotation(
      Line(points = {{-64, 86}, {-44, 86}, {-44, 22}, {-26, 22}}, color = {0, 0, 127}));
    connect(boundary.ports[6], valveCompressibleA1.port_a) annotation(
      Line(points = {{-64, 14}, {-36, 14}}, color = {0, 127, 255}));
    connect(valveCompressibleA1.port_b, boundary_pT.ports[6]) annotation(
      Line(points = {{-16, 14}, {34, 14}, {34, 14}, {34, 14}}, color = {0, 127, 255}));
    annotation(
      experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-06, Interval = 0.02),
      Diagram(coordinateSystem(extent = {{-100, -110}, {100, 110}})),
      Icon(coordinateSystem(extent = {{-100, -110}, {100, 110}})));
  end AngleValveTesrt3;

  model ValveCompressibleB "Valve for compressible fluids, accounts for choked flow conditions"
    extends Modelica.Fluid.Valves.BaseClasses.PartialValve;
    import SI = Modelica.SIunits;
    import Modelica.Fluid.Utilities;
    import Modelica.Fluid.Types.CvTypes;
    import Modelica.Constants.pi;
    parameter Medium.AbsolutePressure p_nominal "Nominal inlet pressure" annotation(
      Dialog(group = "Nominal operating point"));
    parameter Real Fxt_full = 0.5 "Fk*xt critical ratio at full opening";
    replaceable function xtCharacteristic = Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.one constrainedby Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun "Critical ratio characteristic";
    Real Fxt;
    Real x "Pressure drop ratio";
    Real xs "Saturated pressure drop ratio";
    Real Y "Compressibility factor";
    Medium.AbsolutePressure p "Inlet pressure";
    constant SI.ReynoldsNumber Re_turbulent = 4000 "cf. straight pipe for fully open valve -- dp_turbulent increases for closing valve";
    parameter Boolean use_Re = system.use_eps_Re "= true, if turbulent region is defined by Re, otherwise by m_flow_small" annotation(
      Dialog(tab = "Advanced"),
      Evaluate = true);
    SI.AbsolutePressure dp_turbulent = if not use_Re then dp_small else max(dp_small, (Medium.dynamicViscosity(state_a) + Medium.dynamicViscosity(state_b)) ^ 2 * pi / 8 * Re_turbulent ^ 2 / (max(valveCharacteristic(opening_actual), 0.001) * Av * Y * (Medium.density(state_a) + Medium.density(state_b))));
  protected
    parameter Real Fxt_nominal(fixed = false) "Nominal Fxt";
    parameter Real x_nominal(fixed = false) "Nominal pressure drop ratio";
    parameter Real xs_nominal(fixed = false) "Nominal saturated pressure drop ratio";
    parameter Real Y_nominal(fixed = false) "Nominal compressibility factor";
  initial equation
    if CvData == CvTypes.OpPoint then
// Determination of Av by the nominal operating point conditions
// Fxt_nominal = Fxt_full * xtCharacteristic(opening_nominal);
      Fxt_nominal = 0.5;
      x_nominal = dp_nominal / p_nominal;
      xs_nominal = smooth(0, if x_nominal > Fxt_nominal then Fxt_nominal else x_nominal);
      Y_nominal = 1 - abs(xs_nominal) / (3 * Fxt_nominal);
      m_flow_nominal = valveCharacteristic(opening_nominal) * Av * Y_nominal * sqrt(rho_nominal) * Utilities.regRoot(p_nominal * xs_nominal, dp_small);
    else
// Dummy values
      Fxt_nominal = 0;
      x_nominal = 0;
      xs_nominal = 0;
      Y_nominal = 0;
    end if;
  equation
    p = max(port_a.p, port_b.p);
    Fxt = 0.5;
    x = dp / p;
    xs = max(-Fxt, min(x, Fxt));
    Y = sqrt(1 - abs(xs));
// m_flow = valveCharacteristic(opening)*Av*Y*sqrt(d)*sqrt(p*xs);
    if checkValve then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * (if xs >= 0 then Utilities.regRoot(p * xs, dp_turbulent) else 0), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    elseif not allowFlowReversal then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * Utilities.regRoot(p * xs, dp_turbulent), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    else
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * Utilities.regRoot2(p * xs, dp_turbulent, Medium.density(state_a), Medium.density(state_b)), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
/* alternative formulation using smooth(0, ...) -- should not be used as regRoot2 has continuous derivatives
     -- cf. ModelicaTest.Fluid.TestPipesAndValves.DynamicPipeInitialization --
      m_flow = homotopy(valveCharacteristic(opening_actual)*Av*Y*
                          smooth(0, Utilities.regRoot(p*xs, dp_turbulent)*
                          (if xs>=0 then sqrt(Medium.density(state_a)) else sqrt(Medium.density(state_b)))),
                        valveCharacteristic(opening_actual)*m_flow_nominal*dp/dp_nominal);
    */
    end if;
    annotation(
      Documentation(info = "<html>
    <p>Valve model according to the IEC 534/ISA S.75 standards for valve sizing, compressible fluid, no phase change, also covering choked-flow conditions.</p>
    
    <p>
    The parameters of this model are explained in detail in
    <a href=\"modelica://Modelica.Fluid.Valves.BaseClasses.PartialValve\">PartialValve</a>
    (the base model for valves).
    </p>
    
    <p>This model can be used with gases and vapours, with arbitrary pressure ratio between inlet and outlet.</p>
    
    <p>The product Fk*xt is given by the parameter <code>Fxt_full</code>, and is assumed constant by default. The relative change (per unit) of the xt coefficient with the valve opening can be specified by replacing the <code>xtCharacteristic</code> function.</p>
    <p>If <code>checkValve</code> is false, the valve supports reverse flow, with a symmetric flow characteristic curve. Otherwise, reverse flow is stopped (check valve behaviour).</p>
    
    <p>
    The treatment of parameters <strong>Kv</strong> and <strong>Cv</strong> is
    explained in detail in the
    <a href=\"modelica://Modelica.Fluid.UsersGuide.ComponentDefinition.ValveCharacteristics\">User's Guide</a>.
    </p>
    
    </html>", revisions = "<html>
    <ul>
    <li><em>2 Nov 2005</em>
      by <a href=\"mailto:francesco.casella@polimi.it\">Francesco Casella</a>:<br>
         Adapted from the ThermoPower library.</li>
    </ul>
    </html>"));
  end ValveCompressibleB;

  model ValveCompressibleC "Valve for compressible fluids, accounts for choked flow conditions"
    extends Modelica.Fluid.Valves.BaseClasses.PartialValve;
    import SI = Modelica.SIunits;
    import Modelica.Fluid.Utilities;
    import Modelica.Fluid.Types.CvTypes;
    import Modelica.Constants.pi;
    parameter Medium.AbsolutePressure p_nominal "Nominal inlet pressure" annotation(
      Dialog(group = "Nominal operating point"));
    parameter Real Fxt_full = 0.5 "Fk*xt critical ratio at full opening";
    replaceable function xtCharacteristic = Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.one constrainedby Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun "Critical ratio characteristic";
    Real Fxt;
    Real x "Pressure drop ratio";
    Real xs "Saturated pressure drop ratio";
    Real Y "Compressibility factor";
    Medium.AbsolutePressure p "Inlet pressure";
    constant SI.ReynoldsNumber Re_turbulent = 4000 "cf. straight pipe for fully open valve -- dp_turbulent increases for closing valve";
    parameter Boolean use_Re = system.use_eps_Re "= true, if turbulent region is defined by Re, otherwise by m_flow_small" annotation(
      Dialog(tab = "Advanced"),
      Evaluate = true);
    SI.AbsolutePressure dp_turbulent = if not use_Re then dp_small else max(dp_small, (Medium.dynamicViscosity(state_a) + Medium.dynamicViscosity(state_b)) ^ 2 * pi / 8 * Re_turbulent ^ 2 / (max(valveCharacteristic(opening_actual), 0.001) * Av * Y * (Medium.density(state_a) + Medium.density(state_b))));
  protected
    parameter Real Fxt_nominal(fixed = false) "Nominal Fxt";
    parameter Real x_nominal(fixed = false) "Nominal pressure drop ratio";
    parameter Real xs_nominal(fixed = false) "Nominal saturated pressure drop ratio";
    parameter Real Y_nominal(fixed = false) "Nominal compressibility factor";
  initial equation
    if CvData == CvTypes.OpPoint then
// Determination of Av by the nominal operating point conditions
// Fxt_nominal = Fxt_full * xtCharacteristic(opening_nominal);
      Fxt_nominal = 0.5;
      x_nominal = dp_nominal / p_nominal;
      xs_nominal = smooth(0, if x_nominal > Fxt_nominal then Fxt_nominal else x_nominal);
      Y_nominal = 1 - abs(xs_nominal) / (3 * Fxt_nominal);
      m_flow_nominal = valveCharacteristic(opening_nominal) * Av * Y_nominal * sqrt(rho_nominal) * Utilities.regRoot(p_nominal * xs_nominal, dp_small);
    else
// Dummy values
      Fxt_nominal = 0;
      x_nominal = 0;
      xs_nominal = 0;
      Y_nominal = 0;
    end if;
  equation
    p = max(port_a.p, port_b.p);
    Fxt = 0.5;
    x = dp / p;
    xs = max(-Fxt, min(x, Fxt));
    Y = 1 - 2 / 3 * abs(xs);
// m_flow = valveCharacteristic(opening)*Av*Y*sqrt(d)*sqrt(p*xs);
    if checkValve then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * (if xs >= 0 then Utilities.regRoot(p * xs, dp_turbulent) else 0), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    elseif not allowFlowReversal then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * Utilities.regRoot(p * xs, dp_turbulent), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    else
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * Utilities.regRoot2(p * xs, dp_turbulent, Medium.density(state_a), Medium.density(state_b)), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
/* alternative formulation using smooth(0, ...) -- should not be used as regRoot2 has continuous derivatives
     -- cf. ModelicaTest.Fluid.TestPipesAndValves.DynamicPipeInitialization --
      m_flow = homotopy(valveCharacteristic(opening_actual)*Av*Y*
                          smooth(0, Utilities.regRoot(p*xs, dp_turbulent)*
                          (if xs>=0 then sqrt(Medium.density(state_a)) else sqrt(Medium.density(state_b)))),
                        valveCharacteristic(opening_actual)*m_flow_nominal*dp/dp_nominal);
    */
    end if;
    annotation(
      Documentation(info = "<html>
    <p>Valve model according to the IEC 534/ISA S.75 standards for valve sizing, compressible fluid, no phase change, also covering choked-flow conditions.</p>
    
    <p>
    The parameters of this model are explained in detail in
    <a href=\"modelica://Modelica.Fluid.Valves.BaseClasses.PartialValve\">PartialValve</a>
    (the base model for valves).
    </p>
    
    <p>This model can be used with gases and vapours, with arbitrary pressure ratio between inlet and outlet.</p>
    
    <p>The product Fk*xt is given by the parameter <code>Fxt_full</code>, and is assumed constant by default. The relative change (per unit) of the xt coefficient with the valve opening can be specified by replacing the <code>xtCharacteristic</code> function.</p>
    <p>If <code>checkValve</code> is false, the valve supports reverse flow, with a symmetric flow characteristic curve. Otherwise, reverse flow is stopped (check valve behaviour).</p>
    
    <p>
    The treatment of parameters <strong>Kv</strong> and <strong>Cv</strong> is
    explained in detail in the
    <a href=\"modelica://Modelica.Fluid.UsersGuide.ComponentDefinition.ValveCharacteristics\">User's Guide</a>.
    </p>
    
    </html>", revisions = "<html>
    <ul>
    <li><em>2 Nov 2005</em>
      by <a href=\"mailto:francesco.casella@polimi.it\">Francesco Casella</a>:<br>
         Adapted from the ThermoPower library.</li>
    </ul>
    </html>"));
  end ValveCompressibleC;

  model ValveCompressibleD "Valve for compressible fluids, accounts for choked flow conditions"
    extends Modelica.Fluid.Valves.BaseClasses.PartialValve;
    import SI = Modelica.SIunits;
    import Modelica.Fluid.Utilities;
    import Modelica.Fluid.Types.CvTypes;
    import Modelica.Constants.pi;
    parameter Medium.AbsolutePressure p_nominal "Nominal inlet pressure" annotation(
      Dialog(group = "Nominal operating point"));
    // parameter Real Fxt_full = 0.5 "Fk*xt critical ratio at full opening";
    // replaceable function xtCharacteristic = Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.one constrainedby
    //  Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun "Critical ratio characteristic";
    parameter Real C1_full = 23.924 "Fk*xt critical ratio at full opening";
    replaceable function c1Characteristic = Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.one constrainedby Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun "Critical ratio characteristic";
    Real C1;
    Real C2;
    Real Fxt;
    Real x "Pressure drop ratio";
    Real xs "Saturated pressure drop ratio";
    Real Y "Compressibility factor";
    Medium.AbsolutePressure p "Inlet pressure";
    constant SI.ReynoldsNumber Re_turbulent = 4000 "cf. straight pipe for fully open valve -- dp_turbulent increases for closing valve";
    parameter Boolean use_Re = system.use_eps_Re "= true, if turbulent region is defined by Re, otherwise by m_flow_small" annotation(
      Dialog(tab = "Advanced"),
      Evaluate = true);
    SI.AbsolutePressure dp_turbulent = if not use_Re then dp_small else max(dp_small, (Medium.dynamicViscosity(state_a) + Medium.dynamicViscosity(state_b)) ^ 2 * pi / 8 * Re_turbulent ^ 2 / (max(valveCharacteristic(opening_actual), 0.001) * Av * Y * (Medium.density(state_a) + Medium.density(state_b))));
  protected
    parameter Real Fxt_nominal(fixed = false) "Nominal Fxt";
    parameter Real x_nominal(fixed = false) "Nominal pressure drop ratio";
    parameter Real xs_nominal(fixed = false) "Nominal saturated pressure drop ratio";
    parameter Real Y_nominal(fixed = false) "Nominal compressibility factor";
  initial equation
    if CvData == CvTypes.OpPoint then
// Determination of Av by the nominal operating point conditions
      Fxt_nominal = (pi / 2 * C1_full * c1Characteristic(opening_nominal) / 59.64) ^ 2;
      x_nominal = dp_nominal / p_nominal;
      xs_nominal = smooth(0, if x_nominal > Fxt_nominal then Fxt_nominal else x_nominal);
      Y_nominal = 1 - abs(xs_nominal) / (3 * Fxt_nominal);
      m_flow_nominal = valveCharacteristic(opening_nominal) * Av * Y_nominal * sqrt(rho_nominal) * Utilities.regRoot(p_nominal * xs_nominal, dp_small);
    else
// Dummy values
      Fxt_nominal = 0;
      x_nominal = 0;
      xs_nominal = 0;
      Y_nominal = 0;
    end if;
  equation
    p = max(port_a.p, port_b.p);
    C1 = C1_full * c1Characteristic(opening_actual);
    Fxt = (0.5 * pi * C1 / 59.64) ^ 2;
// Fxt = Fxt_full*xtCharacteristic(opening_actual);
    x = dp / p;
    xs = max(-Fxt, min(x, Fxt));
    C2 = 59.64 * sqrt(abs(xs)) / C1;
    Y = sin(C2) / C2;
// m_flow = valveCharacteristic(opening)*Av*Y*sqrt(d)*sqrt(p*xs);
    if checkValve then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * (if xs >= 0 then Utilities.regRoot(p * xs, dp_turbulent) else 0), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    elseif not allowFlowReversal then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * Utilities.regRoot(p * xs, dp_turbulent), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    else
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * Utilities.regRoot2(p * xs, dp_turbulent, Medium.density(state_a), Medium.density(state_b)), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
/* alternative formulation using smooth(0, ...) -- should not be used as regRoot2 has continuous derivatives
     -- cf. ModelicaTest.Fluid.TestPipesAndValves.DynamicPipeInitialization --
      m_flow = homotopy(valveCharacteristic(opening_actual)*Av*Y*
                          smooth(0, Utilities.regRoot(p*xs, dp_turbulent)*
                          (if xs>=0 then sqrt(Medium.density(state_a)) else sqrt(Medium.density(state_b)))),
                        valveCharacteristic(opening_actual)*m_flow_nominal*dp/dp_nominal);
    */
    end if;
    annotation(
      Documentation(info = "<html>
    <p>Valve model according to the IEC 534/ISA S.75 standards for valve sizing, compressible fluid, no phase change, also covering choked-flow conditions.</p>
    
    <p>
    The parameters of this model are explained in detail in
    <a href=\"modelica://Modelica.Fluid.Valves.BaseClasses.PartialValve\">PartialValve</a>
    (the base model for valves).
    </p>
    
    <p>This model can be used with gases and vapours, with arbitrary pressure ratio between inlet and outlet.</p>
    
    <p>The product Fk*xt is given by the parameter <code>Fxt_full</code>, and is assumed constant by default. The relative change (per unit) of the xt coefficient with the valve opening can be specified by replacing the <code>xtCharacteristic</code> function.</p>
    <p>If <code>checkValve</code> is false, the valve supports reverse flow, with a symmetric flow characteristic curve. Otherwise, reverse flow is stopped (check valve behaviour).</p>
    
    <p>
    The treatment of parameters <strong>Kv</strong> and <strong>Cv</strong> is
    explained in detail in the
    <a href=\"modelica://Modelica.Fluid.UsersGuide.ComponentDefinition.ValveCharacteristics\">User's Guide</a>.
    </p>
    
    </html>", revisions = "<html>
    <ul>
    <li><em>2 Nov 2005</em>
      by <a href=\"mailto:francesco.casella@polimi.it\">Francesco Casella</a>:<br>
         Adapted from the ThermoPower library.</li>
    </ul>
    </html>"));
  end ValveCompressibleD;

  model ValveCompressibleA "Valve for compressible fluids, accounts for choked flow conditions"
    extends Modelica.Fluid.Valves.BaseClasses.PartialValve;
    import Modelica.Fluid.Types.CvTypes;
    import Modelica.Constants.pi;
    import SI = Modelica.SIunits;
    import Modelica.Fluid.Utilities;
    parameter Medium.AbsolutePressure p_nominal "Nominal inlet pressure" annotation(
      Dialog(group = "Nominal operating point"));
    // parameter Real Fxt_full=0.5 "Fk*xt critical ratio at full opening";
    parameter Real Fl_max = 1.0;
    //replaceable function xtCharacteristic =
    //    Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.one
    //  constrainedby
    //  Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun
    //  "Critical ratio characteristic";
    replaceable function flCharacteristic = Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.one constrainedby Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun "Pressure Recovery Factor";
    Real Fl;
    Real Fxt;
    Real x "Pressure drop ratio";
    Real xs "Saturated pressure drop ratio";
    Real Y "Compressibility factor";
    Medium.AbsolutePressure p "Inlet pressure";
    constant SI.ReynoldsNumber Re_turbulent = 4000 "cf. straight pipe for fully open valve -- dp_turbulent increases for closing valve";
    parameter Boolean use_Re = system.use_eps_Re "= true, if turbulent region is defined by Re, otherwise by m_flow_small" annotation(
      Dialog(tab = "Advanced"),
      Evaluate = true);
    SI.AbsolutePressure dp_turbulent = if not use_Re then dp_small else max(dp_small, (Medium.dynamicViscosity(state_a) + Medium.dynamicViscosity(state_b)) ^ 2 * pi / 8 * Re_turbulent ^ 2 / (max(valveCharacteristic(opening_actual), 0.001) * Av * Y * (Medium.density(state_a) + Medium.density(state_b))));
  protected
    parameter Real Fxt_nominal(fixed = false) "Nominal Fxt";
    parameter Real x_nominal(fixed = false) "Nominal pressure drop ratio";
    parameter Real xs_nominal(fixed = false) "Nominal saturated pressure drop ratio";
    parameter Real Y_nominal(fixed = false) "Nominal compressibility factor";
  initial equation
    if CvData == CvTypes.OpPoint then
// Determination of Av by the nominal operating point conditions
      Fxt_nominal = 0.5 * (Fl_max * flCharacteristic(opening_nominal)) ^ 2;
      x_nominal = dp_nominal / p_nominal;
      xs_nominal = smooth(0, if x_nominal > Fxt_nominal then Fxt_nominal else x_nominal);
      Y_nominal = 1 - abs(xs_nominal) / (3 * Fxt_nominal);
      m_flow_nominal = valveCharacteristic(opening_nominal) * Av * Y_nominal * sqrt(rho_nominal) * Utilities.regRoot(p_nominal * xs_nominal, dp_small);
    else
// Dummy values
      Fxt_nominal = 0;
      x_nominal = 0;
      xs_nominal = 0;
      Y_nominal = 0;
    end if;
  equation
    p = max(port_a.p, port_b.p);
    Fl = Fl_max * flCharacteristic(opening_actual);
    Fxt = 0.5 * Fl * Fl;
    x = dp / p;
    xs = max(-Fxt, min(x, Fxt));
    Y = sqrt(1 - abs(xs) / 2);
// m_flow = valveCharacteristic(opening)*Av*Y*sqrt(d)*sqrt(p*xs);
    if checkValve then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * (if xs >= 0 then Utilities.regRoot(p * xs, dp_turbulent) else 0), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    elseif not allowFlowReversal then
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * sqrt(Medium.density(state_a)) * Utilities.regRoot(p * xs, dp_turbulent), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
    else
      m_flow = homotopy(valveCharacteristic(opening_actual) * Av * Y * Utilities.regRoot2(p * xs, dp_turbulent, Medium.density(state_a), Medium.density(state_b)), valveCharacteristic(opening_actual) * m_flow_nominal * dp / dp_nominal);
/* alternative formulation using smooth(0, ...) -- should not be used as regRoot2 has continuous derivatives
   -- cf. ModelicaTest.Fluid.TestPipesAndValves.DynamicPipeInitialization --
    m_flow = homotopy(valveCharacteristic(opening_actual)*Av*Y*
                        smooth(0, Utilities.regRoot(p*xs, dp_turbulent)*
                        (if xs>=0 then sqrt(Medium.density(state_a)) else sqrt(Medium.density(state_b)))),
                      valveCharacteristic(opening_actual)*m_flow_nominal*dp/dp_nominal);
  */
    end if;
    annotation(
      Documentation(info = "<html>
  <p>Valve model according to the IEC 534/ISA S.75 standards for valve sizing, compressible fluid, no phase change, also covering choked-flow conditions.</p>
  
  <p>
  The parameters of this model are explained in detail in
  <a href=\"modelica://Modelica.Fluid.Valves.BaseClasses.PartialValve\">PartialValve</a>
  (the base model for valves).
  </p>
  
  <p>This model can be used with gases and vapours, with arbitrary pressure ratio between inlet and outlet.</p>
  
  <p>The product Fk*xt is given by the parameter <code>Fxt_full</code>, and is assumed constant by default. The relative change (per unit) of the xt coefficient with the valve opening can be specified by replacing the <code>xtCharacteristic</code> function.</p>
  <p>If <code>checkValve</code> is false, the valve supports reverse flow, with a symmetric flow characteristic curve. Otherwise, reverse flow is stopped (check valve behaviour).</p>
  
  <p>
  The treatment of parameters <strong>Kv</strong> and <strong>Cv</strong> is
  explained in detail in the
  <a href=\"modelica://Modelica.Fluid.UsersGuide.ComponentDefinition.ValveCharacteristics\">User's Guide</a>.
  </p>
  
  </html>", revisions = "<html>
  <ul>
  <li><em>2 Nov 2005</em>
    by <a href=\"mailto:francesco.casella@polimi.it\">Francesco Casella</a>:<br>
       Adapted from the ThermoPower library.</li>
  </ul>
  </html>"));
  end ValveCompressibleA;

  function flCurve1
    extends Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun;
  algorithm
    rc := ((((((-31.992 * pos) + 107.73) * pos - 132.48) * pos + 70.548) * pos - 13.555) * pos - 0.5709) * pos + 1;
  end flCurve1;

  model CharacteristicTest
    Modelica.Blocks.Sources.Ramp ramp(duration = 10, height = 1, offset = 0, startTime = 0) annotation(
      Placement(visible = true, transformation(origin = {-46, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Tables.CombiTable1Ds combiTable1Ds(
      smoothness = Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
      table = [
        0, 0, 1;
        0.1, 0.051025641, 0.758186398;
        0.2, 0.083948718, 0.516372796;
        0.3, 0.117948718, 0.468513854;
        0.4, 0.15982906, 0.498740554;
        0.5, 0.217094017, 0.518891688;
        0.6, 0.294871795, 0.534005038;
        0.7, 0.41965812, 0.493702771;
        0.8, 0.617094017, 0.400503778;
        0.9, 0.85042735, 0.40302267;
        1, 1, 0.471032746])
      annotation(
      Placement(visible = true, transformation(origin = {2, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(ramp.y, combiTable1Ds.u) annotation(
      Line(points = {{-34, 12}, {-10, 12}, {-10, 12}, {-10, 12}}, color = {0, 0, 127}));
    annotation(
      experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-06, Interval = 0.02));
  end CharacteristicTest;

  model AngleValveTest4
  replaceable package Medium = Modelica.Media.Air.DryAirNasa;
  ValveExample3.ValveCompressibleE valveCompressibleE(
    redeclare package Medium = Medium,
    charactericticTable(
      smoothness = Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
      table = [
        0, 0, 1;
        0.1, 0.051025641, 0.758186398;
        0.2, 0.083948718, 0.516372796;
        0.3, 0.117948718, 0.468513854;
        0.4, 0.15982906, 0.498740554;
        0.5, 0.217094017, 0.518891688;
        0.6, 0.294871795, 0.534005038;
        0.7, 0.41965812, 0.493702771;
        0.8, 0.617094017, 0.400503778;
        0.9, 0.85042735, 0.40302267;
        1, 1, 0.471032746]),
     Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397,
     dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825)  annotation(
      Placement(visible = true, transformation(origin = {0, 2}, extent = {{-10, -10}, {13, 10}}, rotation = 0)));
  Modelica.Fluid.Sources.Boundary_pT boundary(redeclare package Medium = Medium, T = 273.15, nPorts = 2, p = 102825)  annotation(
      Placement(visible = true, transformation(origin = {-56, 2}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Fluid.Sources.Boundary_pT boundary_pT(redeclare package Medium = Medium, T = 273.15, nPorts = 2, p = 101325)  annotation(
      Placement(visible = true, transformation(origin = {52, 2}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
  Modelica.Blocks.Sources.Ramp ramp(duration = 10, height = 1, offset = 0, startTime = 0)  annotation(
      Placement(visible = true, transformation(origin = {-46, 44}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  inner Modelica.Fluid.System system annotation(
      Placement(visible = true, transformation(origin = {48, 46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Fluid.Valves.ValveCompressible valveCompressible(
      redeclare package Medium = Medium,
      redeclare function valveCharacteristic = avCurve1,
      redeclare function xtCharacteristic = xtCurve1,
      Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397,
      dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825)  annotation(
      Placement(visible = true, transformation(origin = {0, -42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(boundary.ports[1], valveCompressibleE.port_a) annotation(
      Line(points = {{-46, 2}, {-10, 2}}, color = {0, 127, 255}));
  connect(valveCompressibleE.port_b, boundary_pT.ports[1]) annotation(
      Line(points = {{10, 2}, {42, 2}}, color = {0, 127, 255}));
  connect(ramp.y, valveCompressibleE.opening) annotation(
      Line(points = {{-35, 44}, {0, 44}, {0, 10}}, color = {0, 0, 127}));
  connect(boundary.ports[2], valveCompressible.port_a) annotation(
      Line(points = {{-46, 2}, {-24, 2}, {-24, -42}, {-10, -42}}, color = {0, 127, 255}));
  connect(valveCompressible.port_b, boundary_pT.ports[2]) annotation(
      Line(points = {{10, -42}, {26, -42}, {26, 2}, {40, 2}, {40, 2}, {42, 2}}, color = {0, 127, 255}));
  connect(ramp.y, valveCompressible.opening) annotation(
      Line(points = {{-34, 44}, {-16, 44}, {-16, -32}, {0, -32}, {0, -34}}, color = {0, 0, 127}));
  annotation(
      __OpenModelica_simulationFlags(lv = "LOG_STATS", outputFormat = "mat", s = "dassl"),
      experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-6, Interval = 0.02));end AngleValveTest4;
  
  model ValveCompressibleE
    "Valve for compressible fluids, accounts for choked flow conditions"
    extends Modelica.Fluid.Valves.BaseClasses.PartialValve;
    import SI = Modelica.SIunits;
    import Modelica.Fluid.Utilities;
    import Modelica.Fluid.Types.CvTypes;
    import Modelica.Constants.pi;
    parameter Medium.AbsolutePressure p_nominal "Nominal inlet pressure"
    annotation(Dialog(group="Nominal operating point"));
    parameter Real Fxt_full=0.5 "Fk*xt critical ratio at full opening";
    replaceable function xtCharacteristic =
        Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.one
      constrainedby
      Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.baseFun
      "Critical ratio characteristic";
    Real Fxt;
    Real x "Pressure drop ratio";
    Real xs "Saturated pressure drop ratio";
    Real Y "Compressibility factor";
    Medium.AbsolutePressure p "Inlet pressure";
  
    constant SI.ReynoldsNumber Re_turbulent = 4000
      "cf. straight pipe for fully open valve -- dp_turbulent increases for closing valve";
    parameter Boolean use_Re = system.use_eps_Re
      "= true, if turbulent region is defined by Re, otherwise by m_flow_small"
      annotation(Dialog(tab="Advanced"), Evaluate=true);
    SI.AbsolutePressure dp_turbulent = if not use_Re then dp_small else
      max(dp_small, (Medium.dynamicViscosity(state_a) + Medium.dynamicViscosity(state_b))^2*pi/8*Re_turbulent^2
                    /(max(valveCharacteristic(opening_actual),0.001)*Av*Y*(Medium.density(state_a) + Medium.density(state_b))));
    Modelica.Blocks.Tables.CombiTable1Ds charactericticTable(table = [0, 0, 0; 1, 1, 1])  annotation(
      Placement(visible = true, transformation(origin = {112, 28}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  protected
    parameter Real Fxt_nominal(fixed=false) "Nominal Fxt";
    parameter Real x_nominal(fixed=false) "Nominal pressure drop ratio";
    parameter Real xs_nominal(fixed=false)
      "Nominal saturated pressure drop ratio";
    parameter Real Y_nominal(fixed=false) "Nominal compressibility factor";
  
  initial equation
    if CvData == CvTypes.OpPoint then
      // Determination of Av by the nominal operating point conditions
      Fxt_nominal = Fxt_full*xtCharacteristic(opening_nominal);
      x_nominal = dp_nominal/p_nominal;
      xs_nominal = smooth(0, if x_nominal > Fxt_nominal then Fxt_nominal else x_nominal);
      Y_nominal = 1 - abs(xs_nominal)/(3*Fxt_nominal);
      m_flow_nominal = valveCharacteristic(opening_nominal)*Av*Y_nominal*sqrt(rho_nominal)*Utilities.regRoot(p_nominal*xs_nominal, dp_small);
    else
      // Dummy values
      Fxt_nominal = 0;
      x_nominal = 0;
      xs_nominal = 0;
      Y_nominal = 0;
    end if;
  
  equation
    p = max(port_a.p, port_b.p);
    // Fxt = Fxt_full*xtCharacteristic(opening_actual);
    Fxt = Fxt_full*charactericticTable.y[2];
    x = dp/p;
    xs = max(-Fxt, min(x, Fxt));
    Y = 1 - abs(xs)/(3*Fxt);
    // m_flow = valveCharacteristic(opening)*Av*Y*sqrt(d)*sqrt(p*xs);
    if checkValve then
      m_flow = homotopy(charactericticTablearacteristicTable.y[1]*Av*Y*sqrt(Medium.density(state_a))*
                             (if xs>=0 then Utilities.regRoot(p*xs, dp_turbulent) else 0),
                        characteristicTable.y[1]*m_flow_nominal*dp/dp_nominal);
    elseif not allowFlowReversal then
      m_flow = homotopy(charactericticTable.y[1]*Av*Y*sqrt(Medium.density(state_a))*
                             Utilities.regRoot(p*xs, dp_turbulent),
                        charactericticTable.y[1]*m_flow_nominal*dp/dp_nominal);
    else
      m_flow = homotopy(charactericticTable.y[1]*Av*Y*
                             Utilities.regRoot2(p*xs, dp_turbulent, Medium.density(state_a), Medium.density(state_b)),
                        charactericticTable.y[1]*m_flow_nominal*dp/dp_nominal);
  /* alternative formulation using smooth(0, ...) -- should not be used as regRoot2 has continuous derivatives
   -- cf. ModelicaTest.Fluid.TestPipesAndValves.DynamicPipeInitialization --
    m_flow = homotopy(valveCharacteristic(opening_actual)*Av*Y*
                        smooth(0, Utilities.regRoot(p*xs, dp_turbulent)*
                        (if xs>=0 then sqrt(Medium.density(state_a)) else sqrt(Medium.density(state_b)))),
                      valveCharacteristic(opening_actual)*m_flow_nominal*dp/dp_nominal);
  */
    end if;
    connect(opening_actual, charactericticTable.u) annotation(
      Line(points = {{70, 20}, {93, 20}, {93, 28}, {100, 28}}, color = {0, 0, 127}));
    annotation (
    Documentation(info = "<html>
  <p>Valve model according to the IEC 534/ISA S.75 standards for valve sizing, compressible fluid, no phase change, also covering choked-flow conditions.</p>
  
  <p>
  The parameters of this model are explained in detail in
  <a href=\"modelica://Modelica.Fluid.Valves.BaseClasses.PartialValve\">PartialValve</a>
  (the base model for valves).
  </p>
  
  <p>This model can be used with gases and vapours, with arbitrary pressure ratio between inlet and outlet.</p>
  
  <p>The product Fk*xt is given by the parameter <code>Fxt_full</code>, and is assumed constant by default. The relative change (per unit) of the xt coefficient with the valve opening can be specified by replacing the <code>xtCharacteristic</code> function.</p>
  <p>If <code>checkValve</code> is false, the valve supports reverse flow, with a symmetric flow characteristic curve. Otherwise, reverse flow is stopped (check valve behaviour).</p>
  
  <p>
  The treatment of parameters <strong>Kv</strong> and <strong>Cv</strong> is
  explained in detail in the
  <a href=\"modelica://Modelica.Fluid.UsersGuide.ComponentDefinition.ValveCharacteristics\">User's Guide</a>.
  </p>
  
  </html>", revisions = "<html>
  <ul>
  <li><em>2 Nov 2005</em>
    by <a href=\"mailto:francesco.casella@polimi.it\">Francesco Casella</a>:<br>
       Adapted from the ThermoPower library.</li>
  </ul>
  </html>"),
      Diagram(coordinateSystem(extent = {{-100, -100}, {130, 100}})),
      Icon(coordinateSystem(extent = {{-100, -100}, {130, 100}})));
  end ValveCompressibleE;
  
  model AngleValveTesrt5
    replaceable package Medium = Modelica.Media.Air.DryAirNasa;
    Modelica.Fluid.Sources.Boundary_pT boundary(redeclare package Medium = Medium, T = 273.15, nPorts = 3, p = 201325) annotation(
      Placement(visible = true, transformation(origin = {-74, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Fluid.Sources.Boundary_pT boundary_pT(redeclare package Medium = Medium, T = 273.15, nPorts = 3, p = 101325, use_p_in = true) annotation(
      Placement(visible = true, transformation(origin = {54, 14}, extent = {{10, -10}, {-10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleE valveCompressible(
      redeclare package Medium = Medium,
      charactericticTable(
      smoothness = Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
      table = [
        0, 0, 1;
        0.1, 0.051025641, 0.758186398;
        0.2, 0.083948718, 0.516372796;
        0.3, 0.117948718, 0.468513854;
        0.4, 0.15982906, 0.498740554;
        0.5, 0.217094017, 0.518891688;
        0.6, 0.294871795, 0.534005038;
        0.7, 0.41965812, 0.493702771;
        0.8, 0.617094017, 0.400503778;
        0.9, 0.85042735, 0.40302267;
        1, 1, 0.471032746]),
      Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397,
      dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-4, 14}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    inner Modelica.Fluid.System system annotation(
      Placement(visible = true, transformation(origin = {54, 52}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Constant const(k = 1) annotation(
      Placement(visible = true, transformation(origin = {-44, 34}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Ramp ramp(duration = 10, height = -90000, offset = 201325) annotation(
      Placement(visible = true, transformation(origin = {48, -26}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleE valveCompressible1(
      redeclare package Medium = Medium,
        charactericticTable(
      smoothness = Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
      table = [
        0, 0, 1;
        0.1, 0.051025641, 0.758186398;
        0.2, 0.083948718, 0.516372796;
        0.3, 0.117948718, 0.468513854;
        0.4, 0.15982906, 0.498740554;
        0.5, 0.217094017, 0.518891688;
        0.6, 0.294871795, 0.534005038;
        0.7, 0.41965812, 0.493702771;
        0.8, 0.617094017, 0.400503778;
        0.9, 0.85042735, 0.40302267;
        1, 1, 0.471032746]),
      Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397,
      dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-2, -22}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    ValveExample3.ValveCompressibleE valveCompressible2(
      redeclare package Medium = Medium,
        charactericticTable(
      smoothness = Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
      table = [
        0, 0, 1;
        0.1, 0.051025641, 0.758186398;
        0.2, 0.083948718, 0.516372796;
        0.3, 0.117948718, 0.468513854;
        0.4, 0.15982906, 0.498740554;
        0.5, 0.217094017, 0.518891688;
        0.6, 0.294871795, 0.534005038;
        0.7, 0.41965812, 0.493702771;
        0.8, 0.617094017, 0.400503778;
        0.9, 0.85042735, 0.40302267;
        1, 1, 0.471032746]),
      Cv = 11.7, CvData = Modelica.Fluid.Types.CvTypes.Cv, Fxt_full = 0.397,
      dp_nominal = 1500, m_flow_nominal = 0.01205483, p_nominal = 102825) annotation(
      Placement(visible = true, transformation(origin = {-2, -56}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Constant const1(k = 0.8) annotation(
      Placement(visible = true, transformation(origin = {-44, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Constant const2(k = 0.4) annotation(
      Placement(visible = true, transformation(origin = {-44, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpression(y = sqrt(valveCompressible.dp / valveCompressible.p)) annotation(
      Placement(visible = true, transformation(origin = {-42, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpression1(y = sqrt(valveCompressible1.dp / valveCompressible1.p)) annotation(
      Placement(visible = true, transformation(origin = {-10, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.RealExpression realExpression2(y = sqrt(valveCompressible2.dp / valveCompressible2.p)) annotation(
      Placement(visible = true, transformation(origin = {26, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(valveCompressible.port_a, boundary.ports[1]) annotation(
      Line(points = {{-14, 14}, {-64, 14}}));
    connect(valveCompressible.port_b, boundary_pT.ports[1]) annotation(
      Line(points = {{6, 14}, {44, 14}}, color = {0, 127, 255}));
    connect(const.y, valveCompressible.opening) annotation(
      Line(points = {{-33, 34}, {-17.5, 34}, {-17.5, 22}, {-4, 22}}, color = {0, 0, 127}));
    connect(ramp.y, boundary_pT.p_in) annotation(
      Line(points = {{59, -26}, {84, -26}, {84, 22}, {66, 22}}, color = {0, 0, 127}));
    connect(boundary.ports[2], valveCompressible1.port_a) annotation(
      Line(points = {{-64, 14}, {-30, 14}, {-30, -22}, {-12, -22}}, color = {0, 127, 255}));
    connect(boundary.ports[3], valveCompressible2.port_a) annotation(
      Line(points = {{-64, 14}, {-30, 14}, {-30, -56}, {-12, -56}}, color = {0, 127, 255}));
    connect(valveCompressible1.port_b, boundary_pT.ports[2]) annotation(
      Line(points = {{8, -22}, {26, -22}, {26, 14}, {44, 14}, {44, 14}, {44, 14}}, color = {0, 127, 255}));
    connect(valveCompressible2.port_b, boundary_pT.ports[3]) annotation(
      Line(points = {{8, -56}, {26, -56}, {26, 14}, {44, 14}, {44, 14}}, color = {0, 127, 255}));
    connect(const1.y, valveCompressible1.opening) annotation(
      Line(points = {{-32, -6}, {-4, -6}, {-4, -12}, {-2, -12}, {-2, -14}}, color = {0, 0, 127}));
    connect(const2.y, valveCompressible2.opening) annotation(
      Line(points = {{-32, -40}, {-2, -40}, {-2, -48}, {-2, -48}}, color = {0, 0, 127}));
    annotation(
      experiment(StartTime = 0, StopTime = 10, Tolerance = 1e-06, Interval = 0.02));
  end AngleValveTesrt5;
  annotation(
    uses(Modelica(version = "3.2.3")));
end ValveExample3;